/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.leospa.main;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;

import com.leospa.bean.Command_0;
import com.leospa.clients.SerialClient;
import com.leospa.properties.ConfigPropertiesFile;
import com.leospae.handler.Command_0_handler;

public class MainScreen extends javax.swing.JFrame implements ActionListener {

	public MainScreen() {
		if (ConfigPropertiesFile.FULLSCREEN_MODE) {
			setUndecorated(true);
			getRootPane().setWindowDecorationStyle(JRootPane.NONE);
		}
		try {
			URL imgURL = new File("./images/backgrond.png").toURI().toURL();
			setContentPane(new JLabel(new ImageIcon(imgURL)));
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
		}
		initComponents();
		setResizable(false);// fixed frame size
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});

	}

	private void initComponents() {
		layout = new javax.swing.GroupLayout(getContentPane());
		getContentPane().setLayout(layout);
		// removeAll();
		LeoSpaMainFrame leoSpaMainFrameNew = new LeoSpaMainFrame(this, layout);
		leoSpaMainFrameNew.setLayout();
		// OptionScreen optionScreen = new OptionScreen(this, layout);
		// optionScreen.setLayout();
	}

	Hashtable scrrenHandler = new Hashtable();

	public void pushScreen(JPanel jPanel, String screenName) {
		scrrenHandler.put(screenName, jPanel);
	}

	public void popScreen(String screenName) {
		scrrenHandler.remove(screenName);
	}

	javax.swing.GroupLayout layout;

	public static void main(String args[]) {
		/* Set the Nimbus look and feel */
		// <editor-fold defaultstate="collapsed" desc=" Look and feel setting
		// code (optional) ">
		/*
		 * If Nimbus (introduced in Java SE 6) is not available, stay with the
		 * default look and feel. For details see
		 * http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.
		 * html
		 */
		try {
			for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
				if ("Nimbus".equals(info.getName())) {
					javax.swing.UIManager.setLookAndFeel(info.getClassName());
					break;
				}
			}
		} catch (ClassNotFoundException ex) {
			java.util.logging.Logger.getLogger(LeoSpaMainFrame.class.getName()).log(java.util.logging.Level.SEVERE,
					null, ex);
		} catch (InstantiationException ex) {
			java.util.logging.Logger.getLogger(LeoSpaMainFrame.class.getName()).log(java.util.logging.Level.SEVERE,
					null, ex);
		} catch (IllegalAccessException ex) {
			java.util.logging.Logger.getLogger(LeoSpaMainFrame.class.getName()).log(java.util.logging.Level.SEVERE,
					null, ex);
		} catch (javax.swing.UnsupportedLookAndFeelException ex) {
			java.util.logging.Logger.getLogger(LeoSpaMainFrame.class.getName()).log(java.util.logging.Level.SEVERE,
					null, ex);
		}

		// </editor-fold>
		MainScreen mainScreen = new MainScreen();
		mainScreen.resetRelaySwitchs();
		mainScreen.setVisible(true);

	}

	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub

	}

	public Boolean resetRelaySwitchs() {

		Hashtable command0_has = new Command_0_handler().getCommand0(this, layout);
		if (command0_has != null && command0_has.size() > 0) {
			Util.getUtilInstance().setCommand_0_hash(command0_has);
		}
		if (command0_has != null) {
			Set entries = command0_has.keySet();
			Iterator itr = entries.iterator();
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("Relay is Ressetting");}
			while (itr.hasNext()) {
				Command_0 command_0 = (Command_0) command0_has.get(itr.next());
				String solarium_id=command_0.getSOLARIUMID();
				MassageTimer massageTimer;
				massageTimer = new MassageTimer(0, command_0.getSOLARIUMID(), 1, 0);
				
				/*if(solarium_id.equals("1")){
					SerialClient.turnRelaySwitch1_Off();
				} else if(solarium_id.equals("2")) {
					SerialClient.turnRelaySwitch2_Off();
				} else if(solarium_id.equals("3")){
					SerialClient.turnRelaySwitch3_Off();
				} else if(solarium_id.equals("4")){
					SerialClient.turnRelaySwitch4_Off();
				}*/
			}
		}

		return true;
	}

}
